<?php $__env->startSection('title', trans($title)); ?>


<?php $__env->startSection('content'); ?>
    <div class="page-header card card-primary m-0 m-md-4 my-4 m-md-0 p-5">
        <div class="row justify-content-between">
            <div class="col-md-12">
                <form action="<?php echo e(route('admin.escrow.search')); ?>" method="get">
                    <div class="row">
                        <div class="col-md-6 col-lg-3">
                            <div class="form-group">
                                <input type="text" name="search" value="<?php echo e(@request()->search); ?>" class="form-control"
                                       placeholder="<?php echo app('translator')->get('Invoice ID'); ?>">
                            </div>
                        </div>

                        <div class="col-md-6 col-lg-3">
                            <div class="form-group">
                                <input type="date" class="form-control" name="date_time" id="datepicker"/>
                            </div>
                        </div>

                        <div class="col-md-6 col-lg-3">
                            <div class="form-group">
                                <select name="status" class="form-control">
                                    <option value=""><?php echo app('translator')->get('All Status'); ?></option>
                                    <option value="pending" <?php if(@request()->status == 'pending'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Pending'); ?></option>
                                    <option value="pending" <?php if(@request()->status == 'hold'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Hold'); ?></option>
                                    <option value="completed" <?php if(@request()->status == 'completed'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Completed'); ?></option>
                                    <option value="disputed" <?php if(@request()->status == 'disputed'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Disputed'); ?></option>
                                    <option value="resolved" <?php if(@request()->status == 'resolved'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Resolved'); ?></option>
                                    <option value="rejected" <?php if(@request()->status == 'rejected'): ?> selected <?php endif; ?>><?php echo app('translator')->get('Rejected'); ?></option>
                                </select>
                            </div>
                        </div>
                        <div class="col-md-6 col-lg-3">
                            <div class="form-group">
                                <button type="submit" class="btn btn-block btn-primary"><i
                                        class="fas fa-search"></i> <?php echo app('translator')->get('Search'); ?></button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>


    <div class="card card-primary m-0 m-md-4 my-4 m-md-0">
        <div class="card-body">


            <div class="table-responsive">
                <table class="categories-show-table table table-hover table-striped table-bordered">
                    <thead class="thead-dark">
                    <tr>
                        <th scope="col"><?php echo app('translator')->get('No.'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Invoice ID'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Invitor'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Invitee'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Title'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Amount'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Status'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Date'); ?></th>
                        <th scope="col"><?php echo app('translator')->get('Action'); ?></th>
                    </tr>
                    </thead>
                    <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $escrowList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                            <td data-label="<?php echo app('translator')->get('No.'); ?>"><?php echo e(loopIndex($escrowList) + $loop->index); ?></td>
                            <td data-label="<?php echo app('translator')->get('Invoice ID'); ?>"><?php echo app('translator')->get($item->invoice); ?></td>
                            <td data-label="<?php echo app('translator')->get('Invitor'); ?>">
                                <a href="<?php echo e(route('admin.user-edit',$item->creator_id)); ?>">
                                    <?php echo app('translator')->get(optional($item->user)->username); ?>
                                </a>

                            </td>
                            <td data-label="<?php echo app('translator')->get('Invitee'); ?>">
                                <a href="<?php echo e(route('admin.user-edit',$item->joiner_id)); ?>">
                                    <?php echo app('translator')->get(optional($item->invitee)->username); ?>
                                </a>
                            </td>
                            <td data-label="<?php echo app('translator')->get('Title'); ?>"><?php echo app('translator')->get(($item->title)? : '-'); ?></td>
                            <td data-label="<?php echo app('translator')->get('Amount'); ?>"><?php echo e(getAmount($item->amount)); ?> <?php echo e(trans(config('basic.currency'))); ?></td>

                            <td data-label="<?php echo app('translator')->get('Status'); ?>">
                                <?php if($item['status'] == 0): ?>
                                    <span class="badge badge-pill badge-secondary"><?php echo e(trans('Pending')); ?></span>
                                <?php elseif($item['status'] == 2): ?>
                                    <span class="badge badge-pill badge-danger"><?php echo e(trans('Rejected')); ?></span>
                                <?php elseif($item['status'] == 1 && $item['payment_status'] == 0): ?>
                                    <span class="badge badge-pill badge-info"><?php echo e(trans('Hold')); ?></span>
                                <?php elseif($item['status'] == 1 && $item['payment_status'] == 1): ?>
                                    <span class="badge badge-pill badge-success"><?php echo e(trans('Completed')); ?></span>
                                <?php elseif($item['status'] == 1 && $item['payment_status'] == 2): ?>
                                    <span class="badge badge-pill badge-warning"><?php echo e(trans('Disputed')); ?></span>
                                <?php elseif($item['status'] == 1 && $item['payment_status'] == 3): ?>
                                    <span class="badge badge-pill badge-primary"><?php echo e(trans('Resolved by Admin')); ?></span>
                                <?php endif; ?>
                            </td>

                            <td data-label="<?php echo app('translator')->get('Date'); ?>">
                                <?php echo e(dateTime($item->created_at)); ?>

                            </td>

                            <td data-label="<?php echo app('translator')->get('Action'); ?>">
                                <div class="dropdown show">
                                    <a class="dropdown-toggle p-3" href="#" id="dropdownMenuLink" data-toggle="dropdown"
                                       aria-haspopup="true" aria-expanded="false">
                                        <i class="fa fa-ellipsis-v" aria-hidden="true"></i>
                                    </a>
                                    <div class="dropdown-menu" aria-labelledby="dropdownMenuLink">
                                        <a class="dropdown-item" href="<?php echo e(route('admin.escrow.details',$item->id)); ?>">
                                            <i class="fa fa-eye text-warning pr-2"
                                               aria-hidden="true"></i> <?php echo app('translator')->get('Details'); ?>
                                        </a>
                                    </div>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td class="text-center text-danger" colspan="9"><?php echo app('translator')->get('No User Data'); ?></td>
                        </tr>
                    <?php endif; ?>
                    </tbody>
                </table>
                <?php echo e($escrowList->appends(@$search)->links('partials.pagination')); ?>


            </div>
        </div>
    </div>





<?php $__env->stopSection(); ?>


<?php $__env->startPush('js'); ?>
    <script>
        "use strict";

        $(document).ready(function () {
            $('select').select2({
                selectOnClose: true
            });
        });

    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/escrow/app.escrow.icu/resources/views/admin/escrow/list.blade.php ENDPATH**/ ?>