<?php $__env->startSection('title', trans('My Escrow')); ?>
<?php $__env->startSection('content'); ?>

    <?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



    <section class="privacy pt-100 pb-100 section--bg overflow-hidden">
        <div class="container">
            <div class="cmn__card betting--card">
                <div class="card__body">
                    <div class="bets__area">
                        <ul class="bets__wrapper">
                            <?php $__empty_1 = true; $__currentLoopData = $myEscrow; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <li class="bets__item position-relative">

                                    <div class="bets__item-content">
                                        <h6 class="bets__item-title"><a
                                                href="javascript:void(0)"><?php echo app('translator')->get($item['title']); ?></a></h6>
                                        <h6 class="bets__item-subtitle"><?php echo e(\Str::limit(trans($item['rules']),150)); ?></h6>
                                        <p class="text-info"><?php echo e(trans('Invoice ID')); ?> : <span
                                                class="text-white"><?php echo e($item['invoice']); ?></span></p>

                                        <span class="bet__balance">
                                        <?php echo e(getAmount($item['amount'])); ?> <?php echo e(trans(config('basic.currency'))); ?>


                                            <?php if($item['status'] == 0): ?>
                                                <span class="badge bg-secondary"><?php echo e(trans('Pending')); ?></span>
                                            <?php elseif($item['status'] == 2): ?>
                                                <span class="badge bg-danger"><?php echo e(trans('Rejected')); ?></span>
                                            <?php elseif($item['status'] == 1 && $item['payment_status'] == 0): ?>
                                                <span class="badge bg-info"><?php echo e(trans('Hold')); ?></span>
                                            <?php elseif($item['status'] == 1 && $item['payment_status'] == 1): ?>
                                                <span class="badge bg-success"><?php echo e(trans('Completed')); ?></span>
                                            <?php elseif($item['status'] == 1 && $item['payment_status'] == 2): ?>
                                                <span class="badge bg-warning"><?php echo e(trans('Disputed')); ?></span>
                                            <?php elseif($item['status'] == 1 && $item['payment_status'] == 3): ?>
                                                <span class="badge bg-primary"><?php echo e(trans('Resolved by Admin')); ?></span>
                                            <?php endif; ?>

                                        </span>
                                    </div>

                                    <div class="more-action">

                                        <div class="dropdown">
                                            <button class="btn btn-dark btn-sm dropdown-toggle" type="button"
                                                    id="dropdownMenuButton1" data-bs-toggle="dropdown">
                                                <span class="visually-hidden"><?php echo e(trans('Toggle Dropdown')); ?></span>

                                                <i class="las la-chevron-circle-down "></i>
                                            </button>
                                            <ul class="dropdown-menu dropdown-menu-dark"
                                                aria-labelledby="dropdownMenuButton1">
                                                <li><a class="dropdown-item seeDetails" href="javascript:void(0)"
                                                       data-title="<?php echo app('translator')->get($item['title']); ?>"
                                                       data-rules="<?php echo app('translator')->get($item['rules']); ?>"
                                                       data-invoice="<?php echo e($item['invoice']); ?>"
                                                       data-amount="<?php echo app('translator')->get(getAmount($item['amount'])); ?>"
                                                       data-created_at="<?php echo e(dateTime($item['created_at'])); ?>"
                                                       data-report="<?php echo e($item['report']); ?>"
                                                       data-invitee_fullname="<?php echo e($item['invitee']['fullname']); ?>"
                                                       data-invitee_email="<?php echo e($item['invitee']['email']); ?>"
                                                       data-invitee_username="<?php echo e($item['invitee']['username']); ?>"

                                                       data-charge="<?php echo e($item['charge']); ?>"
                                                       data-charge_bear="<?php echo e(kebab2Title($item['charge_bear'])); ?>"
                                                       data-image="<?php echo e($item['image']); ?>"
                                                       data-file_location="<?php echo e($item['file_location']); ?>"


                                                       data-bs-toggle="modal"
                                                       data-bs-target="#detailsModal"
                                                    ><i class="la la-eye"></i> <?php echo e(trans('Details')); ?></a></li>

                                                <?php if($item['status'] == 0 && $item['joiner_id'] == auth()->id()): ?>

                                                    <li><a class="dropdown-item rejectModal" href="javascript:void(0)"
                                                           data-id="<?php echo e($item['id']); ?>"
                                                           data-route="<?php echo e(route('user.escrowConfirmation',$item['id'])); ?>"
                                                           data-title="<?php echo app('translator')->get($item['title']); ?>"
                                                           data-rules="<?php echo app('translator')->get($item['rules']); ?>"
                                                           data-invoice="<?php echo e($item['invoice']); ?>"
                                                           data-amount="<?php echo app('translator')->get(getAmount($item['amount'])); ?>"
                                                           data-created_at="<?php echo e(dateTime($item['created_at'])); ?>"
                                                           data-invitee_fullname="<?php echo e($item['invitee']['fullname']); ?>"
                                                           data-invitee_email="<?php echo e($item['invitee']['email']); ?>"
                                                           data-invitee_username="<?php echo e($item['invitee']['username']); ?>"

                                                           data-charge="<?php echo e($item['charge']); ?>"
                                                           data-charge_bear="<?php echo e(kebab2Title($item['charge_bear'])); ?>"
                                                           data-image="<?php echo e($item['image']); ?>"
                                                           data-file_location="<?php echo e($item['file_location']); ?>"

                                                           data-bs-toggle="modal"
                                                           data-bs-target="#rejectModal"
                                                        ><i class="las la-cog"></i> <?php echo e(trans('Accept / Reject')); ?></a>
                                                    </li>


                                                <?php elseif($item['status'] == 1 &&  $item['payment_status'] == 0): ?>
                                                    <?php if($item['creator_id'] == auth()->id()): ?>
                                                        <li><a class="dropdown-item releaseModal"
                                                               href="javascript:void(0)"
                                                               data-id="<?php echo e($item['id']); ?>"
                                                               data-route="<?php echo e(route('user.escrowRelease',$item['id'])); ?>"
                                                               data-title="<?php echo app('translator')->get($item['title']); ?>"
                                                               data-rules="<?php echo app('translator')->get($item['rules']); ?>"
                                                               data-invoice="<?php echo e($item['invoice']); ?>"
                                                               data-amount="<?php echo app('translator')->get(getAmount($item['amount'])); ?>"
                                                               data-created_at="<?php echo e(dateTime($item['created_at'])); ?>"
                                                               data-invitee_fullname="<?php echo e($item['invitee']['fullname']); ?>"
                                                               data-invitee_email="<?php echo e($item['invitee']['email']); ?>"
                                                               data-invitee_username="<?php echo e($item['invitee']['username']); ?>"


                                                               data-charge="<?php echo e($item['charge']); ?>"
                                                               data-charge_bear="<?php echo e(kebab2Title($item['charge_bear'])); ?>"
                                                               data-image="<?php echo e($item['image']); ?>"
                                                               data-file_location="<?php echo e($item['file_location']); ?>"

                                                               data-bs-toggle="modal"
                                                               data-bs-target="#releaseModal"
                                                            ><i class="las la-hand-holding-usd"></i> <?php echo e(trans('Release')); ?>

                                                            </a></li>
                                                    <?php endif; ?>

                                                    <li><a class="dropdown-item reportModal"
                                                           href="javascript:void(0)"
                                                           data-id="<?php echo e($item['id']); ?>"
                                                           data-route="<?php echo e(route('user.escrowToReport',$item['id'])); ?>"
                                                           data-bs-toggle="modal"
                                                           data-bs-target="#reportModal">
                                                            <i class="lab la-hire-a-helper"></i> <?php echo e(trans('Report')); ?>

                                                        </a></li>

                                                <?php elseif($item['status'] == 1 &&  $item['payment_status'] == 2): ?>
                                                    <li><a class="dropdown-item" href="<?php echo e(route('user.escrow.reports',$item['id'])); ?>"><i
                                                                class="las la-comments-dollar"></i> <?php echo e(trans('Chat')); ?>

                                                        </a></li>
                                                <?php endif; ?>
                                            </ul>
                                        </div>
                                    </div>

                                    <div class="bets__item-thumb">
                                        <a href="javascript:void(0)" class="thumb"
                                           title="<?php echo e(@$item['invitee']['profileName']); ?>">
                                            <img
                                                src="<?php echo e(getFile(config('location.user.path').@$item['invitee']['image'])); ?>"
                                                alt="header">
                                        </a>
                                    </div>
                                </li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                <li class="bets__item position-relative">

                                    <div class="bets__item-content w-100">
                                        <h3 class="bets__item-title text-center"><a
                                                href="javascript:void(0)"><?php echo e(trans('No Records Found')); ?></h3>

                                    </div>

                                </li>


                            <?php endif; ?>
                        </ul>
                    </div>

                    <div class="mt-4">
                        <?php echo e($myEscrow->appends($_GET)->links($theme.'partials.pagination')); ?>

                    </div>
                </div>
            </div>
        </div>
    </section>




    <?php $__env->startPush('loadModal'); ?>
        <!---Details--->
        <div id="detailsModal" class="modal fade " tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content form-block">
                    <div class="modal-header">
                        <h6 class="modal-title method-name"></h6>
                        <button type="button" class="close closeModal" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <div class="modal-body">
                        <h6><span class="text--base"><?php echo e(trans('Subject')); ?> :</span> <span class="escrow-title"></span>
                        </h6>
                        <p class="pt-20 "><span class="text--base"><?php echo e(trans('Invoice Id')); ?> : </span> <span
                                class="escrow-invoice"></span></p>
                        <p><span class="text--base"><?php echo e(trans('Amount')); ?> : </span> <span
                                class="badge bg-secondary escrow-amount"></span></p>

                        <p><span class="text--base"><?php echo e(trans('Charge')); ?> : </span> <span
                                class="badge bg-danger charge"></span></p>

                        <p><span class="text--base"><?php echo e(trans('Rules')); ?> : </span> <span class="escrow-rules"></span></p>
                        <p class="show-file"></p>

                        <p><span class="text--base pt-2"><?php echo e(trans('Opponent Fullname')); ?> : </span> <span
                                class="invitor-fullname"></span></p>
                        <p><span class="text--base"><?php echo e(trans('Opponent Email')); ?> : </span> <span
                                class="invitor-email"></span></p>
                        <p><span class="text--base"><?php echo e(trans('Opponent Username')); ?> : </span> <span
                                class="invitor-username"></span></p>
                        <p><span class="text--base"><?php echo e(trans('Invited At')); ?> : </span> <span class="invited-at"></span>
                        </p>


                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-sm btn-dark closeModal"
                                data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                    </div>

                </div>
            </div>
        </div>

        <!---Action Or Reject--->
        <div id="rejectModal" class="modal fade " tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content form-block">
                    <div class="modal-header">
                        <h6 class="modal-title method-name"></h6>
                        <button type="button" class="close closeModal" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <form action="" method="post" class="escrowConfirmation">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <h6><span class="text--base"><?php echo e(trans('Subject')); ?> :</span> <span
                                    class="escrow-title"></span></h6>
                            <p class="pt-20 "><span class="text--base"><?php echo e(trans('Invoice Id')); ?> : </span> <span
                                    class=" escrow-invoice"></span></p>
                            <p><span class="text--base"><?php echo e(trans('Amount')); ?> : </span> <span class="badge bg-secondary escrow-amount"></span></p>

                            <p><span class="text--base"><?php echo e(trans('Charge')); ?> : </span> <span class="badge bg-danger charge"></span></p>


                            <p class="show-file"></p>


                            <p><span class="text--base"><?php echo e(trans('Rules')); ?> : </span> <span class="escrow-rules"></span>
                            </p>


                            <p class="show-file"></p>


                            <p><span class="text--base pt-2"><?php echo e(trans('Opponent Fullname')); ?> : </span> <span
                                    class="invitor-fullname"></span></p>
                            <p><span class="text--base"><?php echo e(trans('Opponent Email')); ?> : </span> <span
                                    class="invitor-email"></span></p>
                            <p><span class="text--base"><?php echo e(trans('Opponent Username')); ?> : </span> <span
                                    class="invitor-username"></span></p>
                            <p><span class="text--base"><?php echo e(trans('Invited At')); ?> : </span> <span
                                    class="invited-at"></span></p>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" name="action" value="accept"
                                    class="btn btn-sm btn-success"><?php echo app('translator')->get('Accept'); ?></button>
                            <button type="submit" name="action" value="reject"
                                    class="btn btn-sm btn-danger"><?php echo app('translator')->get('Reject'); ?></button>
                            <button type="button" class="btn btn-sm btn-dark closeModal"
                                    data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        </div>

                    </form>

                </div>
            </div>
        </div>

        <!---Release--->
        <div id="releaseModal" class="modal fade " tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content form-block">
                    <div class="modal-header">
                        <h6 class="modal-title method-name"></h6>
                        <button type="button" class="close closeModal" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <form action="" method="post" class="releaseConfirmation">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <h6><span class="text--base"><?php echo e(trans('Subject')); ?> :</span> <span
                                    class="escrow-title"></span></h6>
                            <p class="pt-20 "><span class="text--base"><?php echo e(trans('Invoice Id')); ?> : </span> <span
                                    class=" escrow-invoice"></span></p>
                            <p><span class="text--base"><?php echo e(trans('Amount')); ?> : </span> <span
                                    class="badge bg-secondary escrow-amount"></span></p>
                            <p><span class="text--base"><?php echo e(trans('Rules')); ?> : </span> <span class="escrow-rules"></span>
                            </p>

                            <p class="show-file"></p>


                            <p><span class="text--base pt-2"><?php echo e(trans('Opponent Fullname')); ?> : </span> <span
                                    class="invitor-fullname"></span></p>
                            <p><span class="text--base"><?php echo e(trans('Opponent Email')); ?> : </span> <span
                                    class="invitor-email"></span></p>
                            <p><span class="text--base"><?php echo e(trans('Opponent Username')); ?> : </span> <span
                                    class="invitor-username"></span></p>
                            <p><span class="text--base"><?php echo e(trans('Invited At')); ?> : </span> <span
                                    class="invited-at"></span></p>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" name="action" value="release"
                                    class="btn btn-sm btn-success"><?php echo app('translator')->get('Release'); ?></button>
                            <button type="button" class="btn btn-sm btn-dark closeModal"
                                    data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        </div>

                    </form>

                </div>
            </div>
        </div>

        <!---Report--->
        <div id="reportModal" class="modal fade " tabindex="-1" role="dialog">
            <div class="modal-dialog modal-lg" role="document">
                <div class="modal-content form-block">
                    <div class="modal-header">
                        <h6 class="modal-title method-name"></h6>
                        <button type="button" class="close closeModal" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>

                    <form action="" method="post" class="reportConfirmation">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div class="form-group">
                                <label><?php echo e(trans('Write your complain')); ?></label>
                                <textarea name="report" id="report" class="form--control" rows="10" placeholder="<?php echo e(trans('Type Here')); ?>"><?php echo e(old('report')); ?></textarea>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="submit" name="action" value="report"
                                    class="btn btn-sm btn-success"><?php echo app('translator')->get('Report'); ?></button>
                            <button type="button" class="btn btn-sm btn-dark closeModal"
                                    data-dismiss="modal"><?php echo app('translator')->get('Close'); ?></button>
                        </div>

                    </form>

                </div>
            </div>
        </div>


    <?php $__env->stopPush(); ?>


<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>

    <script>
        "use strict";
        var title, rules, amount, currency, created_at, report, inviteeFullname, inviteeEmail, inviteeUsername, invoice,  charge, charge_bear,image,file_location;

        $('.seeDetails').on('click', function () {
            currency = "<?php echo e(trans(config('basic.currency'))); ?>";
            title = $(this).data('title');
            rules = $(this).data('rules');
            amount = $(this).data('amount');
            created_at = $(this).data('created_at');
            report = $(this).data('report');
            invoice = $(this).data('invoice');
            inviteeFullname = $(this).data('invitee_fullname');
            inviteeEmail = $(this).data('invitee_email');
            inviteeUsername = $(this).data('invitee_username')

            charge = $(this).data('charge');
            charge_bear = $(this).data('charge_bear');
            image = $(this).data('image');
            file_location = $(this).data('file_location');

            if(image == ''){
                $('.show-file').html(``);
            }else {
                $('.show-file').html(`<span class="text--base"><?php echo e(trans('Documents')); ?> : </span> <a href="${file_location}" class="text-white">${image}</a>`)
            }

            $('.charge').text(`${charge} ${currency}`);
            $('.charge_bear').text(`${charge_bear}`);
            $('.image').text(`${image}`);
            $('.file_location').text(`${file_location}`);


            $('.method-name').text(`<?php echo app('translator')->get('Details'); ?>`);
            $('.escrow-title').text(title);
            $('.escrow-invoice').text(invoice);
            $('.escrow-amount').text(`${amount} ${currency}`);


            $('.escrow-rules').text(rules);
            $('.invitor-fullname').text(inviteeFullname);
            $('.invitor-email').text(inviteeEmail);
            $('.invitor-username').text(inviteeUsername);
            $('.invited-at').text(created_at);

        });

        $('.rejectModal').on('click', function () {
            currency = "<?php echo e(trans(config('basic.currency'))); ?>";
            title = $(this).data('title');
            rules = $(this).data('rules');
            amount = $(this).data('amount');
            created_at = $(this).data('created_at');
            report = $(this).data('report');
            invoice = $(this).data('invoice');


            charge = $(this).data('charge');
            charge_bear = $(this).data('charge_bear');
            image = $(this).data('image');
            file_location = $(this).data('file_location');

            if(image == ''){
                $('.show-file').html(``);
            }else {
                $('.show-file').html(`<span class="text--base"><?php echo e(trans('Documents')); ?> : </span> <a href="${file_location}" class="text-white">${image}</a>`)
            }

            $('.charge').text(`${charge} ${currency}`);
            $('.charge_bear').text(`${charge_bear}`);
            $('.image').text(`${image}`);
            $('.file_location').text(`${file_location}`);


            inviteeFullname = $(this).data('invitee_fullname');
            inviteeEmail = $(this).data('invitee_email');
            inviteeUsername = $(this).data('invitee_username');

            $('.escrowConfirmation').attr('action', $(this).data('route'))


            $('.method-name').text(`<?php echo app('translator')->get('Confirmation for action'); ?>`);
            $('.escrow-title').text(title);
            $('.escrow-amount').text(`${amount} ${currency}`);
            $('.escrow-rules').text(rules);
            $('.escrow-invoice').text(invoice);


            $('.invitor-fullname').text(inviteeFullname);
            $('.invitor-email').text(inviteeEmail);
            $('.invitor-username').text(inviteeUsername);
            $('.invited-at').text(created_at);
        });


        $('.releaseModal').on('click', function () {
            currency = "<?php echo e(trans(config('basic.currency'))); ?>";
            title = $(this).data('title');
            rules = $(this).data('rules');
            amount = $(this).data('amount');
            created_at = $(this).data('created_at');
            report = $(this).data('report');
            invoice = $(this).data('invoice');


            charge = $(this).data('charge');
            charge_bear = $(this).data('charge_bear');
            image = $(this).data('image');
            file_location = $(this).data('file_location');

            if(image == ''){
                $('.show-file').html(``);
            }else {
                $('.show-file').html(`<span class="text--base"><?php echo e(trans('Documents')); ?> : </span> <a href="${file_location}" class="text-white">${image}</a>`)
            }

            $('.charge').text(`${charge} ${currency}`);
            $('.charge_bear').text(`${charge_bear}`);
            $('.image').text(`${image}`);
            $('.file_location').text(`${file_location}`);


            inviteeFullname = $(this).data('invitee_fullname');
            inviteeEmail = $(this).data('invitee_email');
            inviteeUsername = $(this).data('invitee_username');

            $('.releaseConfirmation').attr('action', $(this).data('route'))


            $('.method-name').text(`<?php echo app('translator')->get('Confirmation for release'); ?>`);
            $('.escrow-title').text(title);
            $('.escrow-amount').text(`${amount} ${currency}`);
            $('.escrow-rules').text(rules);
            $('.escrow-invoice').text(invoice);


            $('.invitor-fullname').text(inviteeFullname);
            $('.invitor-email').text(inviteeEmail);
            $('.invitor-username').text(inviteeUsername);
            $('.invited-at').text(created_at);
        });




        $('.reportModal').on('click', function () {
            $('.reportConfirmation').attr('action', $(this).data('route'))
            $('.method-name').text(`<?php echo app('translator')->get('Report Now'); ?>`);
            $('textarea[name="report"]').val('')

        });


        $('.closeModal').on('click', function (e) {
            $("#detailsModal").modal("hide");
            $("#rejectModal").modal("hide");
            $("#releaseModal").modal("hide");
            $("#reportModal").modal("hide");
        });
    </script>

    <?php if($errors->any()): ?>
        <script>
            'use strict';
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            Notiflix.Notify.Failure(`<?php echo e(trans($error)); ?>`);
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/escrow/app.escrow.icu/resources/views/themes/darkmode/user/escrow/index.blade.php ENDPATH**/ ?>