<?php $__env->startSection('title'); ?>
    <?php echo e('Pay with '.optional($order->gateway)->name ?? ''); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>


    <?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <section class="privacy pt-100 pb-100 section--bg overflow-hidden">
        <div class="container">
            <div class="row ">
                <div class="col-md-12">

                    <div class="card secbg text-center">
                        <div class="card-body d-flex flex-wrap justify-content-evenly align-items-center">
                            <div>
                                <img
                                    src="<?php echo e(getFile(config('location.gateway.path').optional($order->gateway)->image)); ?>"
                                    class=" img-thumbnail mx-auto d-block mb-3 mb-md-0" alt="..">
                            </div>
                            <div>
                                <h4 class="mt-2"><?php echo app('translator')->get('Please Pay'); ?> <?php echo e(getAmount($order->final_amount)); ?> <?php echo e(trans($order->gateway_currency)); ?></h4>
                                <h4 class="mt-1"><?php echo app('translator')->get('To Get'); ?> <?php echo e(getAmount($order->amount)); ?>  <?php echo e(trans($basic->currency)); ?></h4>

                                <button type="button" class="cmn-btn  mt-2" id="btn-confirm"
                                        onClick="payWithRave()"><?php echo app('translator')->get('Pay Now'); ?></button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>



    <?php $__env->startPush('script'); ?>
        <script src="https://api.ravepay.co/flwv3-pug/getpaidx/api/flwpbf-inline.js"></script>
        <script>
            var btn = document.querySelector("#btn-confirm");
            btn.setAttribute("type", "button");
            const API_publicKey = "<?php echo e($data->API_publicKey ?? ''); ?>";

            function payWithRave() {
                var x = getpaidSetup({
                    PBFPubKey: API_publicKey,
                    customer_email: "<?php echo e($data->customer_email ?? 'example@example.com'); ?>",
                    amount: "<?php echo e($data->amount ?? '0'); ?>",
                    customer_phone: "<?php echo e($data->customer_phone ?? '0123'); ?>",
                    currency: "<?php echo e($data->currency ?? 'USD'); ?>",
                    txref: "<?php echo e($data->txref ?? ''); ?>",
                    onclose: function () {
                    },
                    callback: function (response) {
                        let txref = response.tx.txRef;
                        let status = response.tx.status;
                        window.location = '<?php echo e(url('payment/flutterwave')); ?>/' + txref + '/' + status;
                    }
                });
            }
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/escrow/app.escrow.icu/resources/views/themes/darkmode/user/payment/flutterwave.blade.php ENDPATH**/ ?>