<?php $__env->startSection('title', trans('Transaction')); ?>
<?php $__env->startSection('content'); ?>

    <?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



    <section class="privacy pt-100 pb-100 section--bg overflow-hidden">
        <div class="container">
            <div class="row justify-content-between">
                <div class="col-md-12">
                    <div class="card secbg form-block p-0 br-4">
                        <div class="card-body">
                            <form action="<?php echo e(route('user.transaction.search')); ?>" method="get">
                                <div class="row">
                                    <div class="col-md-6  col-lg-3 mb-2">
                                        <div class="form-group">
                                            <input type="text" name="transaction_id"
                                                   value="<?php echo e(@request()->transaction_id); ?>"
                                                   class="form-control"
                                                   placeholder="<?php echo app('translator')->get('Search for Transaction ID'); ?>">
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-lg-3  mb-2">
                                        <div class="form-group">
                                            <input type="text" name="remark" value="<?php echo e(@request()->remark); ?>"
                                                   class="form-control"
                                                   placeholder="<?php echo app('translator')->get('Remark'); ?>">
                                        </div>
                                    </div>


                                    <div class="col-md-6 col-lg-3  mb-2">
                                        <div class="form-group">
                                            <input type="date" class="form-control" name="datetrx" id="datepicker"/>
                                        </div>
                                    </div>

                                    <div class="col-md-6 col-lg-3 mb-2">
                                        <div class="form-group">
                                            <button type="submit" class="w-100 cmn-btn">
                                                <i class="las la-search"></i> <?php echo app('translator')->get('Search'); ?></button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row mt-5">
                <div class="col-md-12">
                    <div class="card secbg">
                        <div class="card-body ">
                            <div class="table-responsive">
                                <table class="table table-dark table-striped text-white" id="service-table">
                                    <thead>
                                    <tr>
                                        <th><?php echo app('translator')->get('SL No.'); ?></th>
                                        <th><?php echo app('translator')->get('Transaction ID'); ?></th>
                                        <th><?php echo app('translator')->get('Amount'); ?></th>
                                        <th><?php echo app('translator')->get('Charge'); ?></th>
                                        <th><?php echo app('translator')->get('Remarks'); ?></th>
                                        <th><?php echo app('translator')->get('Time'); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td data-label="<?php echo app('translator')->get('SL No.'); ?>"><?php echo e(loopIndex($transactions) + $loop->index); ?></td>
                                            <td data-label="<?php echo app('translator')->get('Transaction ID'); ?>"><?php echo app('translator')->get($transaction->trx_id); ?></td>
                                            <td data-label="<?php echo app('translator')->get('Amount'); ?>">
                                        <span
                                            class="font-weight-bold text-<?php echo e(($transaction->trx_type == "+") ? 'success': 'danger'); ?>"> <?php echo e(getAmount($transaction->amount)); ?> <?php echo e(trans(config('basic.currency'))); ?></span>
                                            </td>

                                            <td data-label="<?php echo app('translator')->get('Charge'); ?>">
                                        <span
                                            class="font-weight-bold "><?php echo e(getAmount($transaction->charge)); ?> <?php echo e(trans(config('basic.currency_symbol'))); ?></span>
                                            </td>
                                            <td data-label="<?php echo app('translator')->get('Remarks'); ?>"> <?php echo app('translator')->get($transaction->remarks); ?></td>
                                            <td data-label="<?php echo app('translator')->get('Time'); ?>">
                                                <?php echo e(dateTime($transaction->created_at, 'd M Y h:i A')); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>

                                        <tr class="text-center">
                                            <td colspan="100%"><?php echo e(__('No Data Found!')); ?></td>
                                        </tr>
                                    <?php endif; ?>
                                    </tbody>
                                </table>

                            </div>
                            <?php echo e($transactions->appends($_GET)->links($theme.'partials.pagination')); ?>


                        </div>
                    </div>
                </div>
            </div>


        </div>
    </section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/escrow/app.escrow.icu/resources/views/themes/darkmode/user/transaction/index.blade.php ENDPATH**/ ?>