<?php $__env->startSection('title', trans($title)); ?>
<?php $__env->startSection('content'); ?>

    <?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <section class="privacy pt-100 pb-100 section--bg overflow-hidden">
        <div class="container">

            <div class="row justify-content-center">
                <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-3 col-lg-3 col-md-4  col-sm-6 col-6">
                        <div class="card gateway text-center mb-3">
                            <div class="card-body">
                                <img src="<?php echo e(getFile(config('location.withdraw.path').$gateway->image)); ?>"
                                     alt="<?php echo e($gateway->name); ?>" class="gateway w-100">

                                <div class="card-footer px-0 pb-0">
                                    <button type="button"
                                            data-id="<?php echo e($gateway->id); ?>"
                                            data-name="<?php echo e($gateway->name); ?>"
                                            data-min_amount="<?php echo e(getAmount($gateway->minimum_amount, $basic->fraction_number)); ?>"
                                            data-max_amount="<?php echo e(getAmount($gateway->maximum_amount,$basic->fraction_number)); ?>"
                                            data-percent_charge="<?php echo e(getAmount($gateway->percent_charge,$basic->fraction_number)); ?>"
                                            data-fix_charge="<?php echo e(getAmount($gateway->fixed_charge, $basic->fraction_number)); ?>"
                                            class="cmn-btn w-100 addFund px-0 px-sm-0 lh-xs-35"
                                            data-bs-backdrop='static' data-bs-keyboard='false'
                                            data-bs-toggle="modal"
                                            data-bs-target="#addFundModal"><?php echo app('translator')->get('Payout Now'); ?></button>

                                </div>

                            </div>

                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>





    <?php $__env->startPush('loadModal'); ?>
        <div id="addFundModal" class="modal fade addFundModal" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content form-block">
                    <div class="modal-header">
                        <h6 class="modal-title method-name"></h6>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true" class="white-text">&times;</span>
                        </button>
                    </div>

                    <form action="<?php echo e(route('user.payout.moneyRequest')); ?>" method="post">
                        <?php echo csrf_field(); ?>

                        <div class="modal-body ">
                            <div class="payment-form ">
                                <p class="text-danger depositLimit"></p>
                                <p class="text-danger depositCharge"></p>

                                <input type="hidden" class="gateway" name="gateway" value="">

                                <div class="form-group">
                                    <label><?php echo app('translator')->get('Amount'); ?></label>
                                    <div class="input-group">
                                        <input type="text" class="amount form-control" name="amount">
                                        <span class="input-group-text show-currency"></span>
                                    </div>
                                    <?php $__errorArgs = ['amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="text-danger"><?php echo e($message); ?></span>
                                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                </div>


                            </div>

                        </div>
                        <div class="modal-footer border-top-0">
                            <button type="submit" class="cmn-btn "><?php echo app('translator')->get('Next'); ?><i class="la la-arrow-right"></i>
                            </button>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    <?php $__env->stopPush(); ?>


<?php $__env->stopSection(); ?>



<?php $__env->startPush('script'); ?>
    <script>
        "use strict";
        var id, minAmount, maxAmount, baseSymbol, fixCharge, percentCharge, currency, gateway;

        $('.addFund').on('click', function () {
            id = $(this).data('id');
            gateway = $(this).data('gateway');
            minAmount = $(this).data('min_amount');
            maxAmount = $(this).data('max_amount');
            baseSymbol = "<?php echo e(trans(config('basic.currency_symbol'))); ?>";
            fixCharge = $(this).data('fix_charge');
            percentCharge = $(this).data('percent_charge');
            currency = $(this).data('currency');
            $('.depositLimit').text(`<?php echo app('translator')->get('Transaction Limit'); ?> : ${minAmount} - ${maxAmount}  ${baseSymbol}`);
            var depositCharge = `<?php echo app('translator')->get('Charge'); ?> : ${fixCharge} ${baseSymbol}  ${(0 < percentCharge) ? ' + ' + percentCharge + ' % ' : ''}`;
            $('.depositCharge').text(depositCharge);
            $('.method-name').text(`<?php echo app('translator')->get('Payout By'); ?> ${$(this).data('name')}`);
            $('.show-currency').text("<?php echo e(trans(config('basic.currency'))); ?>");
            $('.gateway').val(id);
        });

        $('.close').on('click', function (e) {
            $('#loading').hide();
            $('.amount').val(``);
            $("#addFundModal").modal("hide");
        });
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/escrow/app.escrow.icu/resources/views/themes/darkmode/user/payout/money.blade.php ENDPATH**/ ?>