<?php $__env->startSection('title'); ?>
    <?php echo e('Pay with '.optional($order->gateway)->name ?? ''); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

    <?php echo $__env->make($theme.'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <section class="privacy pt-100 pb-100 section--bg overflow-hidden">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-12">
                    <div class="card secbg  text-center">
                        <div class="card-body d-flex flex-wrap justify-content-evenly align-items-center">
                            <div>
                                <img
                                    src="<?php echo e(getFile(config('location.gateway.path').optional($order->gateway)->image)); ?>"
                                    class=" img-thumbnail mx-auto d-block mb-3 mb-md-0" alt="..">
                            </div>

                            <div>
                                <h4 class="mt-2 "><?php echo app('translator')->get('Please Pay'); ?> <?php echo e(getAmount($order->final_amount)); ?> <?php echo e(trans($order->gateway_currency)); ?></h4>
                                <h4 class="my-1"><?php echo app('translator')->get('To Get'); ?> <?php echo e(getAmount($order->amount)); ?>  <?php echo e(trans($basic->currency)); ?></h4>

                                <div id="paypal-button-container"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php $__env->startPush('script'); ?>
        <script src="https://www.paypal.com/sdk/js?client-id=<?php echo e($data->cleint_id); ?>">
        </script>
        <script>
            paypal.Buttons({
                createOrder: function (data, actions) {
                    return actions.order.create({
                        purchase_units: [
                            {
                                description: "<?php echo e($data->description); ?>",
                                custom_id: "<?php echo e($data->custom_id); ?>",
                                amount: {
                                    currency_code: "<?php echo e($data->currency); ?>",
                                    value: "<?php echo e($data->amount); ?>",
                                    breakdown: {
                                        item_total: {
                                            currency_code: "<?php echo e($data->currency); ?>",
                                            value: "<?php echo e($data->amount); ?>"
                                        }
                                    }
                                }
                            }
                        ]
                    });
                },
                onApprove: function (data, actions) {
                    return actions.order.capture().then(function (details) {
                        var trx = "<?php echo e($data->custom_id); ?>";
                        window.location = '<?php echo e(url('payment/paypal')); ?>/' + trx + '/' + details.id
                    });
                }
            }).render('#paypal-button-container');
        </script>
    <?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($theme.'layouts.user', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/escrow/app.escrow.icu/resources/views/themes/darkmode/user/payment/paypal.blade.php ENDPATH**/ ?>