<?php $__env->startSection('title',trans($title)); ?>
<?php $__env->startSection('content'); ?>


    <div class="m-0 m-md-4 my-4 m-md-0">
        <div class="row">
            <div class="col-md-12">
                <div class="card shadow">
                    <div class="card-body bg-white d-flex justify-content-between flex-wrap">
                        <h5><span
                                class="text--base pr-3"><?php echo e(trans('Title')); ?> :</span> <?php echo e(trans($escrow->title)); ?>

                        </h5>

                        <?php if($escrow->payment_status ==2): ?>
                        <div>
                            <a href="javascript:void(0)"
                               data-toggle="modal" data-target="#payModal"
                               data-route="<?php echo e(route('admin.escrow.resolve',$escrow->id)); ?>"
                               data-user_id="<?php echo e($escrow->creator_id); ?>"
                               data-username="<?php echo e(optional($escrow->user)->username); ?>"
                               data-id="<?php echo e($escrow->id); ?>"
                               class="btn btn-rounded btn-success btn-sm px-3 payModal"><?php echo e(trans('Pay To')); ?>  <?php echo app('translator')->get(optional($escrow->user)->username); ?></a>


                            <a href="javascript:void(0)"
                               data-toggle="modal" data-target="#payModal"
                               data-route="<?php echo e(route('admin.escrow.resolve',$escrow->id)); ?>"
                               data-user_id="<?php echo e($escrow->joiner_id); ?>"
                               data-username="<?php echo e(optional($escrow->invitee)->username); ?>"
                               data-id="<?php echo e($escrow->id); ?>"

                               class="btn btn-rounded btn-primary btn-sm px-3 payModal"><?php echo e(trans('Pay To')); ?>  <?php echo app('translator')->get(optional($escrow->invitee)->username); ?></a>
                        </div>
                        <?php endif; ?>

                    </div>
                </div>
            </div>

            <div class="  <?php echo e((in_array($escrow['payment_status'],[2,3])) ? 'col-lg-7' : 'col-lg-12'); ?> ">
                <div class="card shadow">
                    <div class="card-body">
                        <article>
                            <div class="post-details ">
                                <div class="post-inner">

                                    <div class="post-content">

                                        <div class="entry-content pl-0">
                                            <p class="mb-3">
                                                <span class="text--base pr-3"><?php echo e(trans('Invoice ID')); ?> :</span>
                                                <?php echo e($escrow->invoice); ?>

                                            </p>
                                            <p class="mb-3">
                                                <span class="text--base pr-3"><?php echo e(trans('Amount')); ?> :</span>
                                                 <?php echo e(trans(config('basic.currency_symbol'))); ?><?php echo e(getAmount($escrow->amount)); ?>

                                            </p>
                                            <p class="mb-3">
                                                <span class="text--base pr-3"><?php echo e(trans('Charge')); ?> :</span>
                                                 <?php echo e(trans(config('basic.currency_symbol'))); ?><?php echo e(getAmount($charge)); ?>

                                            </p>
                                            <p class="mb-3">
                                                <span class="text--base pr-3"><?php echo e(trans('Charge Will Bear')); ?> :</span>
                                                 <span class="font-weight-bold"><?php echo e(trans(kebab2Title($escrow->charge_bear))); ?></span>
                                            </p>

                                            <p class="mb-4">
                                                <span class="text--base pr-3"><?php echo e(trans('Status')); ?> :</span>
                                                <?php if($escrow['status'] == 0): ?>
                                                    <span
                                                        class="badge badge-pill badge-secondary"><?php echo e(trans('Pending')); ?></span>
                                                <?php elseif($escrow['status'] == 2): ?>
                                                    <span
                                                        class="badge badge-pill badge-danger"><?php echo e(trans('Rejected')); ?></span>
                                                <?php elseif($escrow['status'] == 1 && $escrow['payment_status'] == 0): ?>
                                                    <span class="badge badge-pill badge-info"><?php echo e(trans('Hold')); ?></span>
                                                <?php elseif($escrow['status'] == 1 && $escrow['payment_status'] == 1): ?>
                                                    <span
                                                        class="badge badge-pill badge-success"><?php echo e(trans('Completed')); ?></span>
                                                <?php elseif($escrow['status'] == 1 && $escrow['payment_status'] == 2): ?>
                                                    <span
                                                        class="badge badge-pill badge-warning"><?php echo e(trans('Disputed')); ?></span>
                                                <?php elseif($escrow['status'] == 1 && $escrow['payment_status'] == 3): ?>
                                                    <span
                                                        class="badge badge-pill badge-primary"><?php echo e(trans('Resolved by Admin')); ?></span>
                                                <?php endif; ?>
                                            </p>

                                            <?php if($escrow['status'] == 1 && $escrow['payment_status'] == 3): ?>
                                            <p class="mb-4">
                                                <span class="text--base pr-3"><?php echo e(trans('Justice Favor')); ?> :</span>
                                                <a href="<?php echo e(route('admin.user-edit',$escrow->favor_id)); ?>"
                                                   target="_blank">
                                                    <?php echo e(optional($escrow->favor)->username); ?>

                                                </a>
                                            </p>
                                            <?php endif; ?>


                                            <?php if($escrow->report): ?>
                                                <p class="mb-3 mt-2">
                                                    <span class="text--base pr-3"><?php echo e(trans('Report')); ?> :</span>
                                                    <?php echo app('translator')->get($escrow->report); ?></p>
                                                <p class="mb-4">
                                                    <span class="text--base pr-3"><?php echo e(trans('Reported By')); ?> :</span>
                                                    <a href="<?php echo e(route('admin.user-edit',$escrow->reported_by)); ?>"
                                                       target="_blank">
                                                        <?php echo e(optional($escrow->reporter)->username); ?>

                                                    </a>
                                                </p>
                                            <?php endif; ?>

                                            <p class="mb-5"><span
                                                    class="text--base pr-3"><?php echo e(trans('Rules')); ?> :</span> <?php echo app('translator')->get($escrow->rules); ?>
                                            </p>


                                            <?php if($escrow->image): ?>
                                                <p class="mb-4 d-flex">
                                                    <span class="text--base pr-3"><?php echo e(trans('Documents')); ?> :</span>
                                                    <a href="<?php echo e($file_location); ?>" ><?php echo e($escrow->image); ?></a>
                                                </p>
                                            <?php endif; ?>



                                            <table class="table table-bordered shadow-sm">
                                                <thead class="thead-dark">
                                                <th scope="col"><?php echo e(trans('Information')); ?></th>
                                                <th scope="col"><?php echo e(trans('Host')); ?></th>
                                                <th scope="col"><?php echo e(trans('Guest')); ?></th>
                                                </thead>
                                                <tbody>
                                                <tr>
                                                    <td><?php echo e(trans('Username')); ?></td>
                                                    <td>
                                                        <a href="<?php echo e(route('admin.user-edit',$escrow->creator_id)); ?>"
                                                           target="_blank">
                                                            <?php echo app('translator')->get(optional($escrow->user)->username); ?>
                                                        </a>
                                                    </td>
                                                    <td>
                                                        <a href="<?php echo e(route('admin.user-edit',$escrow->joiner_id)); ?>"
                                                           target="_blank">
                                                            <?php echo app('translator')->get(optional($escrow->invitee)->username); ?>
                                                        </a>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td><?php echo e(trans('Fullname')); ?></td>
                                                    <td>
                                                        <?php echo app('translator')->get(optional($escrow->user)->fullname); ?>
                                                    </td>
                                                    <td>
                                                        <?php echo app('translator')->get(optional($escrow->invitee)->fullname); ?>
                                                    </td>
                                                </tr>


                                                <tr>
                                                    <td><?php echo e(trans('Email')); ?></td>
                                                    <td>
                                                        <?php echo app('translator')->get(optional($escrow->user)->email); ?>
                                                    </td>
                                                    <td>
                                                        <?php echo app('translator')->get(optional($escrow->invitee)->email); ?>
                                                    </td>
                                                </tr>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </article>
                    </div>
                </div>
            </div>

            <?php if(in_array($escrow['payment_status'],[2,3])): ?>
            <div class="col-lg-5">
                <div class="p-3 mb-4 shadow">
                    <div class="report  justify-content-center " id="pushChatArea">
                        <audio id="myAudio">
                            <source src="<?php echo e(asset('assets/admin/css/sound.mp3')); ?>" type="audio/mpeg">
                        </audio>

                        <div class="card ">
                            <div class="adiv flex-row justify-content-start text-white">
                                <p class="p-2 "><i class="fas fa-users "></i> <?php echo e(trans('Conversation')); ?></p>
                            </div>
                            <div class="chat-length" ref="chatArea">
                                <div v-for="(item, index) in items">
                                    <div
                                        v-if=" item.chat_notificational_type == auth_model"
                                        class="d-flex flex-row justify-content-end p-3 "
                                        :title="item.chat_notificational.username">
                                        <div class="bg-white mr-2 pt-1 pb-4  pl-2 pr-2 position-relative mw-130">
                                            <span class="text-wa">{{item.description}}</span>
                                            <span class="timmer">{{item.formatted_date}}</span>

                                        </div>
                                        <img
                                            :src="item.chat_notificational.photo"
                                            width="30" height="30">
                                    </div>

                                    <div v-else class="d-flex flex-row justify-content-start p-3"
                                         :title="item.chat_notificational.username">
                                        <img :src="item.chat_notificational.photo" width="30" height="30">
                                        <div class="chat ml-2 pt-1 pb-4  pl-2 pr-5 position-relative mw-130">
                                            {{item.description}}
                                            <span class="timmer">{{item.formatted_date}}</span>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <form @submit.prevent="send" enctype="multipart/form-data" method="post">
                            <div class="writing-box d-flex justify-content-between align-items-center">
                                <div class="input--group form-group px-3 ">
                                    <input class="form--control type_msg" v-model.trim="message"
                                           placeholder="<?php echo e(trans('Type your message')); ?>"/>
                                </div>
                                <div class="send text-center">
                                    <button type="button" class="btn btn-success btn--success " @click="send">
                                        <i class="fas fa-paper-plane "></i>
                                    </button>
                                </div>
                            </div>

                            </form>

                        </div>


                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </div>




    <!-- Modal for Edit button -->
    <div class="modal fade" id="payModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
         aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content ">
                <div class="modal-header modal-colored-header bg-primary">
                    <h4 class="modal-title" id="myModalLabel"><?php echo app('translator')->get('Payment Release confirmation'); ?></h4>
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                </div>

                <form role="form" method="POST" class="actionRoute" action="" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('put'); ?>
                    <div class="modal-body">
                        <p><?php echo app('translator')->get('Are you want to release payment to'); ?> <span class="username text-info"></span> <?php echo e(trans('?')); ?></p>
                    </div>
                    <div class="modal-footer">
                        <input type="hidden" name="receiver_id">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal"><?php echo app('translator')->get('Cancel'); ?></button>
                        <button type="submit" class="btn btn-primary"><?php echo app('translator')->get('Confirm'); ?></button>
                    </div>

                </form>


            </div>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>

    <script>
        'use strict';
        let pushChatArea = new Vue({
            el: "#pushChatArea",
            data: {
                items: [],
                auth_id: "<?php echo e(auth()->guard('admin')->id()); ?>",
                auth_model: "App\\Models\\Admin",
                message: ''
            },
            beforeMount() {
                this.getNotifications();
                this.pushNewItem();
            },
            methods: {
                getNotifications() {
                    let app = this;
                    axios.get("<?php echo e(route('admin.push.chat.show',$escrow->id)); ?>")
                        .then(function (res) {
                            // console.log(res.data)
                            app.items = res.data;
                        })
                },

                pushNewItem() {
                    let app = this;
                    // Pusher.logToConsole = true;
                    let pusher = new Pusher("<?php echo e(env('PUSHER_APP_KEY')); ?>", {
                        encrypted: true,
                        cluster: "<?php echo e(env('PUSHER_APP_CLUSTER')); ?>"
                    });

                    let channel = pusher.subscribe('user-chat-notification.' + "<?php echo e($escrow->id); ?>");
                    channel.bind('App\\Events\\UserChatNotification', function (data) {
                        app.items.push(data.message);

                        var x = document.getElementById("myAudio");
                        x.play();

                        Vue.nextTick(() => {
                            let messageDisplay = app.$refs.chatArea
                            messageDisplay.scrollTop = messageDisplay.scrollHeight
                        })


                    });
                    channel.bind('App\\Events\\UpdateChatUserNotification', function (data) {
                        app.getNotifications();
                        console.log('update')
                    });
                },

                send() {
                    let app = this;
                    if (app.message.length == 0) {
                        Notiflix.Notify.Failure(`<?php echo e(trans('Type your message')); ?>`);
                        return 0;
                    }

                    // app.items = res.data;

                    axios.post("<?php echo e(route('admin.push.chat.newMessage')); ?>", {
                        escrowId: "<?php echo e($escrow->id); ?>",
                        message: app.message
                    }).then(function (res) {

                        if (res.data.errors) {
                            var err = res.data.errors;
                            for (const property in err) {
                                Notiflix.Notify.Failure(`${err[property]}`);
                            }
                        }

                        if (res.data.success == true) {
                            app.message = '';
                            Vue.nextTick(() => {
                                let messageDisplay = app.$refs.chatArea
                                messageDisplay.scrollTop = messageDisplay.scrollHeight
                            })
                        }
                    }).catch(function (error) {

                    });

                }
            }
        });
    </script>


    <script>
        "use strict";
        $(document).on("click", '.payModal', function (e) {
            var id = $(this).data('id');
            $('.username').text($(this).data('username'));
            $('input[name=receiver_id]').val($(this).data('user_id'));
            $(".actionRoute").attr('action', $(this).data('route'));
        });

    </script>



    <?php if($errors->any()): ?>
        <script>
            'use strict';
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            Notiflix.Notify.Failure(`<?php echo e(trans($error)); ?>`);
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/escrow/app.escrow.icu/resources/views/admin/escrow/details.blade.php ENDPATH**/ ?>