<!DOCTYPE html>
<html lang="en" <?php if(session()->get('rtl') == 1): ?> dir="rtl" <?php endif; ?> >
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <?php echo $__env->make('partials.seo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/bootstrap.min.css')); ?>"/>

    <?php echo $__env->yieldPushContent('css-lib'); ?>

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/line-awesome.min.css')); ?>"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/all.min.css')); ?>"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/nice-select.css')); ?>"/>

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/owl.min.css')); ?>"/>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset($themeTrue.'css/main.css')); ?>"/>
    <?php echo $__env->yieldPushContent('style'); ?>

</head>

<body>

<div class="loader">
    <div class="loader-inner">
        <div class="loader-line-wrap">
            <div class="loader-line"></div>
        </div>
        <div class="loader-line-wrap">
            <div class="loader-line"></div>
        </div>
        <div class="loader-line-wrap">
            <div class="loader-line"></div>
        </div>
        <div class="loader-line-wrap">
            <div class="loader-line"></div>
        </div>
        <div class="loader-line-wrap">
            <div class="loader-line"></div>
        </div>
    </div>
</div>


<!--=======Header=======-->
<header>
    <div class="container">
        <div class="header__wrapper">
            <div class="left__side">
                <div class="logo">
                    <a href="<?php echo e(route('home')); ?>">
                        <img src="<?php echo e(getFile(config('location.logoIcon.path').'logo.png')); ?>" alt="logo">
                    </a>
                </div>
            </div>
            <div class="right__side">
                <ul class="menu">
                    <li>
                        <a href="<?php echo e(route('home')); ?>"><?php echo app('translator')->get('Home'); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('about')); ?>"> <?php echo app('translator')->get('About Us'); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('blog')); ?>"><?php echo app('translator')->get('Blog'); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('contact')); ?>"><?php echo app('translator')->get('Contact'); ?></a>
                    </li>

                    <?php if(auth()->guard()->guest()): ?>
                    <li>
                        <a href="<?php echo e(route('login')); ?>"><?php echo e(trans('Sign In')); ?></a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('register')); ?>"><?php echo e(trans('Sign Up')); ?></a>
                    </li>
                    <?php endif; ?>

                    <?php if(auth()->guard()->check()): ?>
                    <li>
                        <a href="javascript:void(0)"><?php echo e(trans('My Profile')); ?></a>
                        <ul class="submenu">
                            <li>
                                <a class="<?php echo e(menuActive(['user.home'])); ?>" href="<?php echo e(route('user.home')); ?>"><?php echo app('translator')->get('Dashboard'); ?></a>
                            </li>

                            <li>
                                <a class="<?php echo e(menuActive(['user.profile'])); ?>" href="<?php echo e(route('user.profile')); ?>"><?php echo app('translator')->get('Profile Settings'); ?></a>
                            </li>

                            <li>
                                <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                                document.getElementById('logout-form').submit();"><?php echo e(trans('Logout')); ?></a>

                                <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                    <?php echo csrf_field(); ?>
                                </form>
                            </li>
                        </ul>
                    </li>
                    <?php endif; ?>



                </ul>
                <div class="header-bar d-md-none me-2">
                    <span></span>
                    <span></span>
                    <span></span>
                </div>
                <select class="select-bar language">
                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e(strtoupper($language->short_name)); ?>"><?php echo app('translator')->get($language->name); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </select>
            </div>
        </div>
    </div>
</header>
<!--=======Header=======-->




<?php echo $__env->yieldContent('content'); ?>


<?php echo $__env->make($theme.'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<script src="<?php echo e(asset($themeTrue.'js/jquery-3.6.0.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/bootstrap.min.js')); ?>"></script>

<?php echo $__env->yieldPushContent('extra-js'); ?>
<script src="<?php echo e(asset($themeTrue.'js/notiflix-aio-2.7.0.min.js')); ?>"></script>

<script src="<?php echo e(asset($themeTrue.'js/nice-select.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/owl.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/pusher.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/vue.min.js')); ?>"></script>
<script src="<?php echo e(asset($themeTrue.'js/axios.min.js')); ?>"></script>

<script src="<?php echo e(asset($themeTrue.'js/main.js')); ?>"></script>


<?php if(auth()->guard()->check()): ?>
    <script>
        'use strict';
        let pushNotificationArea = new Vue({
            el: "#pushNotificationArea",
            data: {
                items: [],
            },
            beforeMount() {
                this.getNotifications();
                this.pushNewItem();
            },
            methods: {
                getNotifications() {
                    let app = this;
                    axios.get("<?php echo e(route('user.push.notification.show')); ?>")
                        .then(function (res) {
                            app.items = res.data;
                        })
                },
                readAt(id, link) {
                    let app = this;
                    let url = "<?php echo e(route('user.push.notification.readAt', 0)); ?>";
                    url = url.replace(/.$/, id);
                    axios.get(url)
                        .then(function (res) {
                            if (res.status) {
                                app.getNotifications();
                                if (link != '#') {
                                    window.location.href = link
                                }
                            }
                        })
                },
                readAll() {
                    let app = this;
                    let url = "<?php echo e(route('user.push.notification.readAll')); ?>";
                    axios.get(url)
                        .then(function (res) {
                            if (res.status) {
                                app.items = [];
                            }
                        })
                },
                pushNewItem() {
                    let app = this;
                    // Pusher.logToConsole = true;
                    let pusher = new Pusher("<?php echo e(env('PUSHER_APP_KEY')); ?>", {
                        encrypted: true,
                        cluster: "<?php echo e(env('PUSHER_APP_CLUSTER')); ?>"
                    });
                    let channel = pusher.subscribe('user-notification.' + "<?php echo e(Auth::id()); ?>");
                    channel.bind('App\\Events\\UserNotification', function (data) {
                        app.items.unshift(data.message);
                    });
                    channel.bind('App\\Events\\UpdateUserNotification', function (data) {
                        app.getNotifications();
                    });
                }
            }
        });
    </script>
<?php endif; ?>

<?php echo $__env->yieldPushContent('script'); ?>
<?php if(session()->has('success')): ?>
    <script>
        Notiflix.Notify.Success("<?php echo app('translator')->get(session('success')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('error')): ?>
    <script>
        Notiflix.Notify.Failure("<?php echo app('translator')->get(session('error')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('warning')): ?>
    <script>
        Notiflix.Notify.Warning("<?php echo app('translator')->get(session('warning')); ?>");
    </script>
<?php endif; ?>

<script>
    $(document).ready(function () {
        $(".language").on('change', function (){
            window.location.href = "<?php echo e(route('language')); ?>/" + $(this).val()
        })
    })
</script>


</body>
</html>
<?php /**PATH C:\xampp\htdocs\codecanyon-gd9RdQbf-payescrow-online-payment-processing-service\Files\resources\views/themes/darkmode/layouts/app.blade.php ENDPATH**/ ?>